using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.WebApplication
{
    public class Learning : Gemini.Core.WebApplication.Base.WebPageComponent
    {
        public delegate void VoidEventHandler();

        /// <summary>
        /// Rodzaje stron jakie sa obslugiwane
        /// </summary>
        public enum PageType
        {
            /// <summary>
            /// Strona gwna nauczania - lista kompetencji glownych
            /// </summary>
            Panel_Main = 0,

            /// <summary>
            /// Panel kompetencji glownej z wyborem kometencji skladowych (lista kompetencji skladowych)
            /// </summary>
            Panel_Competence = 1,

            /// <summary>
            /// Panel pokazujcy kompetencje skladowa z lista dostepnych kursow
            /// </summary>
            Panel_CompetencePart = 2,

            /// <summary>
            /// Panel pokazujcy sam kurs
            /// </summary>
            Panel_Course = 3,

            /// <summary>
            /// Panel gry flash eduFarma
            /// </summary>
            Panel_eduFarma = 4,
        }

        private const string COMPETENCE_BANER_PARAM = "CompetenceBaner";
        private const string COURSE_BANER_PARAM = "CourseBaner";
        private const string COURSE_IMAGE_PARAM = "CourseImg";
        private const string COURSE_AUDIO_PARAM = "CourseAudio";

        public Learning(Gemini.Core.WebApplication.Interface.IWebPageComponentParam WebPageComponentParam): base(WebPageComponentParam){}

        private BL.ZSBELearning _blZSBELearning = null;
        public BL.ZSBELearning ZSBELearning
        {
            get
            {
                if (_blZSBELearning == null)
                {
                    _blZSBELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(Environment);
                }
                return _blZSBELearning;
            }
        }

        private PI.FM.N005.VariableRepository.BL.VariableRepository _blVariableRepository = null;
        public PI.FM.N005.VariableRepository.BL.VariableRepository BLVariableRepository
        {
            get
            {
                if (_blVariableRepository == null)
                {
                    _blVariableRepository = new PI.FM.N005.VariableRepository.BL.VariableRepository(Environment);
                }
                return _blVariableRepository;
            }
        }


        private bool _instructorRestored = false;
        private BL.BO.Instructor _instructor = null;
        public BL.BO.Instructor BOInstructor
        {
            get
            {
                if (!_instructorRestored)
                {
                    _instructor = ZSBELearning.Instructor.RestoreByUser(Environment.User);
                    _instructorRestored = true;
                }
                return _instructor;
            }
        }

        private bool _studentrestored = false;
        private BL.BO.Student _student = null;
        private BL.BO.Student BOStudent
        {
            get
            {
                if (!_studentrestored)
                {
                    _student = ZSBELearning.Student.RestoreByUser(Environment.User);
                    _studentrestored = true;
                }
                return _student;
            }
        }

        public override long ClientID
        {
            get { return ZSBELearning.ClientID; }
        }

        public override bool Save()
        {
            return true;
        }

        // potrzebne do renderowania w przypadku studenta
        private BL.BO.Class _class = null;

        public override void Load()
        {
            try
            {
                if (WebPageEngine.IsUserAuthorized)
                {
                    //Gemini.Utility.Debug.SendTraceViaEmali(GetSessionStackInfo(), String.Empty);
                    if (BOStudent != null)
                    {
                        #region Student
                        // tryb pracy studenta, wywietlenie ekranu powitalnego, dalej ju AJAXy
                        XML.Element.Add("UserStudent", 1);

                        XML.Element.Start("Student");
                        XML.Element.Attribute("CurrentAdvancedLevelID", BOStudent.CurrentAdvancedLevelID);
                        XML.Element.Attribute("ClassID", BOStudent.ClassID);
                        XML.Element.Attribute("Email", BOStudent.Email);
                        XML.Element.Attribute("CompetenceEvaluationSheetID", BOStudent.CompetenceEvaluationSheetID);
                        XML.Element.Attribute("Forename", BOStudent.Forename);
                        XML.Element.Attribute("ID", BOStudent.ID);
                        XML.Element.Attribute("IndexNr", BOStudent.IndexNr);
                        XML.Element.Attribute("Sex", BOStudent.Sex);
                        XML.Element.Attribute("Surename", BOStudent.Surename);
                        XML.Element.Attribute("UserBID", BOStudent.UserID);
                        XML.Element.End();

                        _class = ZSBELearning.Class.Restore(BOStudent);
                        XML.Element.Start("Class");
                        XML.Element.Attribute("ID", _class.ID);
                        XML.Element.Attribute("InstructorID", _class.InstructorID);
                        XML.Element.Attribute("Name", _class.Name);
                        XML.Element.Attribute("SchoolID", _class.SchoolID);
                        XML.Element.End();

                        BL.BO.School _school = ZSBELearning.School.Restore(_class.SchoolID);
                        XML.Element.Start("School");
                        XML.Element.Attribute("AddressLine1", _school.AddressLine1);
                        XML.Element.Attribute("AddressLine2", _school.AddressLine2);
                        XML.Element.Attribute("Email", _school.Email);
                        XML.Element.Attribute("Fax", _school.Fax);
                        XML.Element.Attribute("ID", _school.ID);
                        XML.Element.Attribute("Name", _school.Name);
                        XML.Element.Attribute("PostCode", _school.PostCode);
                        XML.Element.Attribute("Tel", _school.Tel);
                        XML.Element.Attribute("Town", _school.Town);
                        XML.Element.End();

                        BL.BO.Instructor _instructorLocal = ZSBELearning.Instructor.Restore(_class.InstructorID);
                        XML.Element.Start("Instructor");
                        XML.Element.Attribute("Email", _instructorLocal.Email);
                        XML.Element.Attribute("Forename", _instructorLocal.Forename);
                        XML.Element.Attribute("ID", _instructorLocal.ID);
                        XML.Element.Attribute("SchoolID", _instructorLocal.SchoolID);
                        XML.Element.Attribute("Surename", _instructorLocal.Surename);
                        XML.Element.Attribute("Tel", _instructorLocal.Tel);
                        XML.Element.Attribute("Title", _instructorLocal.Title);
                        XML.Element.End();
                        #endregion
                    }
                    else if (BOInstructor != null)
                    {
                        #region Instructor
                        // tryb pracy instruktora, wywietlenie ekranu powitalnego, dalej ju AJAXy
                        XML.Element.Add("UserInstructor", 1);

                        XML.Element.Start("Instructor");
                        XML.Element.Attribute("Email", BOInstructor.Email);
                        XML.Element.Attribute("Forename", BOInstructor.Forename);
                        XML.Element.Attribute("ID", BOInstructor.ID);
                        XML.Element.Attribute("SchoolID", BOInstructor.SchoolID);
                        XML.Element.Attribute("Surename", BOInstructor.Surename);
                        XML.Element.Attribute("Tel", BOInstructor.Tel);
                        XML.Element.Attribute("Title", BOInstructor.Title);
                        XML.Element.End();

                        BL.BO.School _school = ZSBELearning.School.Restore(BOInstructor.SchoolID);
                        XML.Element.Start("School");
                        XML.Element.Attribute("AddressLine1", _school.AddressLine1);
                        XML.Element.Attribute("AddressLine2", _school.AddressLine2);
                        XML.Element.Attribute("Email", _school.Email);
                        XML.Element.Attribute("Fax", _school.Fax);
                        XML.Element.Attribute("ID", _school.ID);
                        XML.Element.Attribute("Name", _school.Name);
                        XML.Element.Attribute("PostCode", _school.PostCode);
                        XML.Element.Attribute("Tel", _school.Tel);
                        XML.Element.Attribute("Town", _school.Town);
                        XML.Element.End();
                        #endregion
                    }
                    else
                    {
                        return;
                    }
                    PI.FM.N001.Account.BL.BO.User _user = Environment.User as PI.FM.N001.Account.BL.BO.User;
                    if (_user != null)
                    {
                        XML.Element.Start("User");
                        XML.Element.Attribute("CountLogin", _user.CountLogin);
                        XML.Element.Attribute("DateLastInvalidLogin", _user.DateLastInvalidLogin, Gemini.Utility.Normalize.DateTimeFormatType.Full);
                        XML.Element.Attribute("DateLastLogin", _user.DateLastLogin, Gemini.Utility.Normalize.DateTimeFormatType.Full);
                        XML.Element.End();
                    }
                    Random _random = new Random();
                    XML.Element.Add("RandomValue", _random.Next(1, 999999));

                    PageType _pageType = GetPageType();
                    XML.Element.Add("PageType", (int)_pageType);
                    switch (_pageType)
                    {
                        case PageType.Panel_Main:
                            Render_Panel_Main();
                            break;
                        case PageType.Panel_Competence:
                            Render_Panel_Competence();
                            break;
                        case PageType.Panel_CompetencePart:
                            Render_Panel_CompetencePart(true);
                            break;
                        case PageType.Panel_Course:
                            Render_Panel_Course();
                            break;
                        case PageType.Panel_eduFarma:
                            Render_Panel_eduFarma();
                            break;
                    }
                }
            }
            catch (Exception _exception)
            {
                Gemini.Utility.Debug.SendExeptionViaEmali(Environment.ProjectName,_exception, String.Format("{0}{1}", Environment.Domain, Environment.URL));
                throw _exception;
            }
        }

        public override bool IsValid
        {
            get { return ((WebPageEngine.IsUserAuthorized) && ((BOStudent != null) || (BOInstructor != null))); }
        }

        public override bool IsParamKey(long ParamKey)
        {
            return false;
        }

        public override object GetParamKey(long ParamKey, params object[] Params)
        {
            return null;
        }

        /// <summary>
        /// Pobiera typ strony z parameru w URLu
        /// </summary>
        /// <returns></returns>
        private PageType GetPageType()
        {
            try
            {
                return (PageType)Environment.GetRequestParamInt("pt");
            }
            catch { }
            return PageType.Panel_Main;
        }

        private void Render_Panel_Main()
        {
            #region Rozpocznij nauke
            if ((BL.Dictionary.GroupType)Environment.User.GroupEnumID == BL.Dictionary.GroupType.Student)
            {
                BL.ZSBELearning.ContextParam _validContext = ZSBELearning.Utility.GetValidContext(BOStudent);
                AppendValidContext(_validContext);
            }
            #endregion

            #region Start, End Course
            long? _startKnowledgeTestCourseID = BLVariableRepository.GetLong(BL.Dictionary.Config.Tests.StartKnowledgeTest.CourseID, BL.Dictionary.Clients.PlugIn);
            long? _startAdvancedTestCourseID = BLVariableRepository.GetLong(BL.Dictionary.Config.Tests.StartAdvancedTest.CourseID, BL.Dictionary.Clients.PlugIn);
            long? _endKnowledgeTestCourseID = BLVariableRepository.GetLong(BL.Dictionary.Config.Tests.EndKnowledgeTest.CourseID, BL.Dictionary.Clients.PlugIn);
            long? _endAdvancedTestCourseID = BLVariableRepository.GetLong(BL.Dictionary.Config.Tests.EndAdvancedTest.CourseID, BL.Dictionary.Clients.PlugIn);

            if (_startKnowledgeTestCourseID.HasValue)
            {
                AppendCourseToXML(ZSBELearning.BLELearning.Course.Restore(_startKnowledgeTestCourseID), "StartKnowledgeTestCourse", 
                    delegate
                    {
                        XML.Element.Attribute("ImageURL", BLVariableRepository.GetString(BL.Dictionary.Config.Tests.StartKnowledgeTest.ImageURL, BL.Dictionary.Clients.PlugIn));
                        XML.Element.Attribute("ContextID", BL.Dictionary.Config.Tests.StartKnowledgeTest.ContextObjectID);
                    }
                );
            }
            if (_startAdvancedTestCourseID.HasValue)
            {
                AppendCourseToXML(ZSBELearning.BLELearning.Course.Restore(_startAdvancedTestCourseID), "StartAdvancedTestCourse",
                    delegate
                    {
                        XML.Element.Attribute("ImageURL", BLVariableRepository.GetString(BL.Dictionary.Config.Tests.StartAdvancedTest.ImageURL, BL.Dictionary.Clients.PlugIn));
                        XML.Element.Attribute("ContextID", BL.Dictionary.Config.Tests.StartAdvancedTest.ContextObjectID);
                    }
                );
            }
            if (_endKnowledgeTestCourseID.HasValue)
            {
                AppendCourseToXML(ZSBELearning.BLELearning.Course.Restore(_endKnowledgeTestCourseID), "EndKnowledgeTestCourse",
                    delegate
                    {
                        XML.Element.Attribute("ImageURL", BLVariableRepository.GetString(BL.Dictionary.Config.Tests.EndKnowledgeTest.ImageURL, BL.Dictionary.Clients.PlugIn));
                        XML.Element.Attribute("ContextID", BL.Dictionary.Config.Tests.EndKnowledgeTest.ContextObjectID);
                    }
                );
            }
            if (_endAdvancedTestCourseID.HasValue)
            {
                AppendCourseToXML(ZSBELearning.BLELearning.Course.Restore(_endAdvancedTestCourseID), "EndAdvancedTestCourse",
                    delegate
                    {
                        XML.Element.Attribute("ImageURL", BLVariableRepository.GetString(BL.Dictionary.Config.Tests.EndAdvancedTest.ImageURL, BL.Dictionary.Clients.PlugIn));
                        XML.Element.Attribute("ContextID", BL.Dictionary.Config.Tests.EndAdvancedTest.ContextObjectID);
                    }
                );
            }
            #endregion

            #region eduFarma
            string _eduFarmaAddress = BLVariableRepository.GetString(BL.Dictionary.Config.eduFarma.GameAddress, BL.Dictionary.Clients.PlugIn);
            string _eduFarmaImageURL = BLVariableRepository.GetString(BL.Dictionary.Config.eduFarma.ImageURL, BL.Dictionary.Clients.PlugIn);
            XML.Element.Start("eduFarma");
            XML.Element.Attribute("eduFarmaAddress", _eduFarmaAddress);
            XML.Element.Attribute("eduFarmaImageURL", _eduFarmaImageURL);
            XML.Element.End();
            #endregion

            #region Kompetencje gwne
            BL.BO.Competence.Search _search = new BL.BO.Competence.Search();
            _search.IsActive = true;
            List<BL.BO.View.Competence> _listCompetence = ZSBELearning.Competence.View.Restore(_search);
            XML.Element.Start("CompetenceList");
            foreach (BL.BO.View.Competence _loopCompetence in _listCompetence)
            {
                XML.Element.Start("Competence");
                XML.Element.Attribute("ID", _loopCompetence.ID);
                XML.Element.Attribute("ImageFileURL", _loopCompetence.ImageFileURL);
                XML.Element.Attribute("IsActive", _loopCompetence.IsActive);
                XML.Element.Attribute("Name", _loopCompetence.Name);
                XML.Element.Attribute("Weight", _loopCompetence.Weight);
                XML.Element.End();
            }
            XML.Element.End();
            #endregion
        }

        private void Render_Panel_eduFarma()
        {
            #region eduFarma
            string _eduFarmaAddress = BLVariableRepository.GetString(BL.Dictionary.Config.eduFarma.GameAddress, BL.Dictionary.Clients.PlugIn);
            string _eduFarmaImageURL = BLVariableRepository.GetString(BL.Dictionary.Config.eduFarma.ImageURL, BL.Dictionary.Clients.PlugIn);
            XML.Element.Start("eduFarma");
            XML.Element.Attribute("eduFarmaAddress", _eduFarmaAddress);
            XML.Element.Attribute("eduFarmaImageURL", _eduFarmaImageURL);

            if ((BL.Dictionary.GroupType)Environment.User.GroupEnumID == BL.Dictionary.GroupType.Student)
            {
                BL.ZSBELearning.ContextParam _validContext = ZSBELearning.Utility.GetValidContext(BOStudent);

                bool? _fgRules = Environment.GetRequestParamBool("fgrules");


                if ((_validContext == null) || (_fgRules == true))
                {
                    XML.Element.Attribute("accessGranted", 1);
                }
                else
                {
                    XML.Element.Attribute("accessGranted", 0);
                    AppendValidContext(_validContext);
                }
            }
            else
            {
                XML.Element.Attribute("accessGranted", 1);
            }

            XML.Element.End();
            #endregion

            #region Config
            XML.Element.Start("Config");
            XML.Element.Attribute("IUA", WebPageEngine.IsUserAuthorized ? "1" : "0");
            if (Environment.User != null)
            {
                XML.Element.Attribute("UserID", Environment.User.ID);
            }
            if (Environment.SessionManager != null && Environment.SessionManager.Current != null)
            {
                XML.Element.Attribute("SessionUID", Environment.SessionManager.Current.UID);
            }
            XML.Element.End();
            #endregion
        }

        private void Render_Panel_Competence()
        {
            long? _competenceID = Environment.GetRequestParamLong("competenceid");
            if (_competenceID.HasValue && _competenceID > 0)
            {
                BL.BO.Competence _Competence = ZSBELearning.Competence.Restore(_competenceID);
                if (_Competence != null)
                {
                    #region Kompetencja gwna
                    XML.Element.Start("Competence");
                    XML.Element.Attribute("ID", _Competence.ID);
                    XML.Element.Attribute("ImageFileURL", _Competence.ImageFileURL);
                    XML.Element.Attribute("IsActive", _Competence.IsActive);
                    XML.Element.Attribute("Name", _Competence.Name);
                    XML.Element.Attribute("Weight", _Competence.Weight);
                    XML.Element.Attribute("Abbreviation", _Competence.Abbreviation);
                    XML.Element.End();

                    string _competenceDescriptionID = GetHTMLCodeID();
                    XML.Element.Add("CompetenceDescriptionID", _competenceDescriptionID);
                    WebPageEngine.HTMLCode.Add(_competenceDescriptionID, _Competence.Description);
                    #endregion

                    #region Kompetencje skadowe
                    BL.BO.CompetencePart.Search _search = new BL.BO.CompetencePart.Search();
                    _search.CompetenceID = _competenceID;
                    _search.IsActive = true;
                    _search.IsValid = true;
                    List<BL.BO.View.CompetencePart> _listCompetencePart = ZSBELearning.CompetencePart.View.Restore(_search);
                    XML.Element.Start("CompetencePartList");
                    foreach (BL.BO.View.CompetencePart _loopCompetencePart in _listCompetencePart)
                    {
                        XML.Element.Start("CompetencePart");
                        XML.Element.Attribute("Abbreviation", _loopCompetencePart.Abbreviation);
                        XML.Element.Attribute("ID", _loopCompetencePart.ID);
                        XML.Element.Attribute("ImageFileURL", _loopCompetencePart.ImageFileURL);
                        XML.Element.Attribute("IsActive", _loopCompetencePart.IsActive);
                        XML.Element.Attribute("Name", _loopCompetencePart.Name);
                        XML.Element.Attribute("Weight", _loopCompetencePart.Weight);
                        XML.Element.End();
                    }
                    XML.Element.End();
                    #endregion
                }
            }
        }

        private bool Render_Panel_CompetencePart(bool WithCourses)
        {
            long? _competenceID = Environment.GetRequestParamLong("competenceid");
            long? _partID = Environment.GetRequestParamLong("partid");
            if (_competenceID.HasValue && _competenceID > 0 && _partID.HasValue && _partID > 0)
            {
                #region Kompetencja gwna
                BL.BO.Competence _Competence = ZSBELearning.Competence.Restore(_competenceID);
                if (_Competence != null)
                {
                    XML.Element.Start("Competence");
                    XML.Element.Attribute("ID", _Competence.ID);
                    XML.Element.Attribute("ImageFileURL", _Competence.ImageFileURL);
                    XML.Element.Attribute("IsActive", _Competence.IsActive);
                    XML.Element.Attribute("Name", _Competence.Name);
                    XML.Element.Attribute("Weight", _Competence.Weight);
                    XML.Element.Attribute("Abbreviation", _Competence.Abbreviation);
                    XML.Element.End();

                    if (!string.IsNullOrEmpty(_Competence.Description))
                    {
                        string _competenceDescriptionID = GetHTMLCodeID();
                        XML.Element.Add("CompetenceDescriptionID", _competenceDescriptionID);
                        WebPageEngine.HTMLCode.Add(_competenceDescriptionID, _Competence.Description);
                    }
                }
                #endregion

                #region Kompetencja skadowa
                BL.BO.CompetencePart _CompetencePart = ZSBELearning.CompetencePart.Restore(_partID);
                if (_CompetencePart != null)
                {
                    XML.Element.Start("CompetencePart");
                    XML.Element.Attribute("ID", _CompetencePart.ID);
                    XML.Element.Attribute("ImageFileURL", _CompetencePart.ImageFileURL);
                    XML.Element.Attribute("IsActive", _CompetencePart.IsActive);
                    XML.Element.Attribute("IsValid", _CompetencePart.IsValid);
                    XML.Element.Attribute("Name", _CompetencePart.Name);
                    XML.Element.Attribute("Weight", _CompetencePart.Weight);
                    XML.Element.Attribute("Abbreviation", _CompetencePart.Abbreviation);
                    XML.Element.Attribute("CompetenceID", _CompetencePart.CompetenceID);

                    XML.Element.Attribute("CaseAbbreviation", _CompetencePart.CaseAbbreviation);
                    XML.Element.Attribute("CaseID", _CompetencePart.CaseID);
                    XML.Element.Attribute("CaseImageFileID", _CompetencePart.CaseImageFileID);
                    XML.Element.Attribute("CaseImageFileURL", _CompetencePart.CaseImageFileURL);

                    XML.Element.Attribute("CompetenceCourseAbbreviation", _CompetencePart.CompetenceCourseAbbreviation);
                    XML.Element.Attribute("CompetenceCourseID", _CompetencePart.CompetenceCourseID);
                    XML.Element.Attribute("CompetenceCourseImageFileID", _CompetencePart.CompetenceCourseImageFileID);
                    XML.Element.Attribute("CompetenceCourseImageFileURL", _CompetencePart.CompetenceCourseImageFileURL);
                    
                    XML.Element.Attribute("CompetenceTheoryAbbreviation", _CompetencePart.CompetenceTheoryAbbreviation);
                    XML.Element.Attribute("CompetenceTheoryID", _CompetencePart.CompetenceTheoryID);
                    XML.Element.Attribute("CompetenceTheoryImageFileID", _CompetencePart.CompetenceTheoryImageFileID);
                    XML.Element.Attribute("CompetenceTheoryImageFileURL", _CompetencePart.CompetenceTheoryImageFileURL);

                    XML.Element.End();
                    if (WithCourses)
                    {
                        PI.GM.N610.ELearning.BL.BO.Course _courseCase = ZSBELearning.BLELearning.Course.Restore(_CompetencePart.CaseID);
                        PI.GM.N610.ELearning.BL.BO.Course _courseCourse = ZSBELearning.BLELearning.Course.Restore(_CompetencePart.CompetenceCourseID);
                        PI.GM.N610.ELearning.BL.BO.Course _courseTheory = ZSBELearning.BLELearning.Course.Restore(_CompetencePart.CompetenceTheoryID);

                        AppendCourseToXML(_courseCase, "CourseCase", null);
                        AppendCourseToXML(_courseCourse, "CourseCourse", null);
                        AppendCourseToXML(_courseTheory, "CourseTheory", null);
                    }

                    if (!string.IsNullOrEmpty(_CompetencePart.Description))
                    {
                        string _competencePartDescriptionID = GetHTMLCodeID();
                        XML.Element.Add("CompetencePartDescriptionID", _competencePartDescriptionID);
                        WebPageEngine.HTMLCode.Add(_competencePartDescriptionID, _CompetencePart.Description);
                    }
                }
                #endregion

                return (_Competence != null) && (_CompetencePart != null);
            }
            return false;
        }

        private void AppendCourseToXML(PI.GM.N610.ELearning.BL.BO.Course Course, string ElementName, VoidEventHandler AdditionalAtributes)
        {
            if (Course == null)
            {
                return;
            }

            XML.Element.Start(ElementName);
            XML.Element.Attribute("ID", Course.ID);
            XML.Element.Attribute("BranchID", Course.BranchID);
            XML.Element.Attribute("DifficultyID", Course.DifficultyID);
            XML.Element.Attribute("IsActive", Course.IsActive);
            XML.Element.Attribute("ISO639_3", Course.ISO639_3);
            XML.Element.Attribute("Title", Course.Title);
            XML.Element.Attribute("TypeID", Course.TypeID);

            if (AdditionalAtributes != null)
            {
                AdditionalAtributes();
            }

            XML.Element.End();

            if (!string.IsNullOrEmpty(Course.Description))
            {
                string _descriptionID = GetHTMLCodeID();
                XML.Element.Add(ElementName + "DescriptionID", _descriptionID);
                WebPageEngine.HTMLCode.Add(_descriptionID, Course.Description);
            }
        }

        private void AppendValidContext(BL.ZSBELearning.ContextParam ContextParam)
        {
            if (ContextParam.ValidContext != null)
            {
                 XML.Element.Start("ValidContext");
                 if ((ContextParam.ValidContext.CourseType == BL.Dictionary.Category.CourseType.Case) || (ContextParam.ValidContext.CourseType == BL.Dictionary.Category.CourseType.CompetenceCourse))
                {
                    XML.Element.Attribute("start", "0");
                    XML.Element.Attribute("pt", "3");
                    XML.Element.Attribute("partid", ContextParam.ValidContext.CompetencePart.ID);
                    XML.Element.Attribute("competenceid", ContextParam.ValidContext.CompetencePart.CompetenceID);
                    XML.Element.Attribute("contextid", ContextParam.ValidContext.ContextObjectID);
                    XML.Element.Attribute("courseid", ContextParam.ValidContext.Course.ID);

                    switch (ContextParam.ValidContext.CourseType)
                    {
                        case BL.Dictionary.Category.CourseType.CompetenceCourse: XML.Element.Attribute("coursetype", 2); break;
                        case BL.Dictionary.Category.CourseType.Case:             XML.Element.Attribute("coursetype", 1); break;
                    }
                }
                else
                {
                    if (ContextParam.ValidContext.ContextObjectID == BL.Dictionary.Config.Tests.StartKnowledgeTest.ContextObjectID)
                    {
                        XML.Element.Attribute("start", "1");
                        XML.Element.Attribute("coursetype", 10);
                    }
                    else if (ContextParam.ValidContext.ContextObjectID == BL.Dictionary.Config.Tests.StartAdvancedTest.ContextObjectID)
                    {
                        XML.Element.Attribute("start", "0");
                        XML.Element.Attribute("coursetype", 11);
                    }
                    else if (ContextParam.ValidContext.ContextObjectID == BL.Dictionary.Config.Tests.EndKnowledgeTest.ContextObjectID)
                    {
                        XML.Element.Attribute("start", "0");
                        XML.Element.Attribute("coursetype", 12);
                    }
                    else if (ContextParam.ValidContext.ContextObjectID == BL.Dictionary.Config.Tests.EndAdvancedTest.ContextObjectID)
                    {
                        XML.Element.Attribute("start", "0");
                        XML.Element.Attribute("coursetype", 13);
                    }

                    XML.Element.Attribute("pt", "3");
                    XML.Element.Attribute("contextid", ContextParam.ValidContext.ContextObjectID);
                    XML.Element.Attribute("courseid", ContextParam.ValidContext.Course.ID);
                }
                XML.Element.End();
            }
        }

        private void Render_Panel_Course()
        {
            long? _coursetype = Environment.GetRequestParamLong("coursetype");

            if (!_coursetype.HasValue)
            {
                XML.Element.Add("IsPanelValid", 0);
                NoValidMaterial(XML);
                return;
            }

            if (_coursetype < 10)
            {
                if (!Render_Panel_CompetencePart(false))
                {
                    XML.Element.Add("IsPanelValid", 0);
                    NoValidMaterial(XML);
                    return;
                }
            }

            long? _contextid = Environment.GetRequestParamLong("contextid");
            XML.Element.Add("IsPanelValid", 1);
            XML.Element.Add("CourseType", _coursetype);
            XML.Element.Add("ContextID", _contextid);
                        
            #region Kurs
            int? _courseID = Environment.GetRequestParamInt("courseid", null);
            if (_courseID == null)
            {
                NoValidMaterial(XML);
                return;
            }


            BL.ZSBELearning.ContextParam _contextParam = ZSBELearning.Exercise.Navigation.RestoreStartExercise(Environment.User,_contextid, _courseID, null);

            if (_contextParam.Course == null)
            {
                NoValidMaterial(XML);
                return;
            }

            XML.Element.Start("Course");
            XML.Element.Attribute("Title"       , _contextParam.Course.Title);
            XML.Element.Attribute("BranchID"    , _contextParam.Course.BranchID);
            XML.Element.Attribute("DifficultyID", _contextParam.Course.DifficultyID);
            XML.Element.Attribute("ID"          , _contextParam.Course.ID);
            XML.Element.Attribute("IsActive"    , _contextParam.Course.IsActive);
            XML.Element.Attribute("ISO639_3"    , _contextParam.Course.ISO639_3);
            if (_contextParam.AuxyliaryPages == BL.Dictionary.AuxyliaryPagesType.None)
            {
                XML.Element.Attribute("firstUnitID", _contextParam.UnitOut.ID);
                XML.Element.Attribute("firstExerciseID", _contextParam.ExerciseOut.ID);
            }
            else
            {
                XML.Element.Attribute("firstUnitID", 0);
                XML.Element.Attribute("firstExerciseID", (int)_contextParam.AuxyliaryPages);
            }
            XML.Element.Attribute("CousreTypeID", (int)_contextParam.CourseType);
            XML.Element.Attribute("ModeID", (int)_contextParam.Mode);
            XML.Element.End();

            if (!string.IsNullOrEmpty(_contextParam.Course.Description))
            {
                string _descriptionID = GetHTMLCodeID();
                XML.Element.Add("CourseDescriptionID", _descriptionID);
                WebPageEngine.HTMLCode.Add(_descriptionID, _contextParam.Course.Description);
            }
            #endregion        
        }

        private void NoValidMaterial(Gemini.Core.WebApplication.Base.GXML XML)
        {
            XML.Element.Start("Course");
            XML.Element.Attribute("Title", "Bd");
            XML.Element.Attribute("BranchID", 0);
            XML.Element.Attribute("DifficultyID", 0);
            XML.Element.Attribute("ID", 0);
            XML.Element.Attribute("IsActive", 0);
            XML.Element.Attribute("ISO639_3", "");
            XML.Element.Attribute("firstUnitID", 0);
            XML.Element.Attribute("firstExerciseID", (int)BL.Dictionary.AuxyliaryPagesType.Error);
            XML.Element.End();
        }
    }
}
